#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <time.h>

#define NANISH 0x7ffc000000000000
#define NANISH_MASK 0xffff000000000000

#define BOOLEAN_MASK 0x7ffe000000000002
#define INTEGER_MASK 0x7ffc000000000000
#define OBJECT_MASK 0xfffc000000000000
#define STRING_MASK 0xfffe000000000000

#define NULL_VALUE 0x7ffe000000000000
#define TRUE_VALUE (BOOLEAN_MASK | 3)
#define FALSE_VALUE (BOOLEAN_MASK | 2)

#define IS_DOUBLE(v) ((v.as_uint64 & NANISH) != NANISH)
#define IS_OBJECT_PTR(v) ((v.as_uint64 & NANISH_MASK) == OBJECT_MASK)
#define IS_STRING_PTR(v) ((v.as_uint64 & NANISH_MASK) == STRING_MASK)
#define IS_NULL(v) (v.as_uint64 == NULL_VALUE)
#define IS_BOOL(v) ((v.as_uint64 & BOOLEAN_MASK) == BOOLEAN_MASK)
#define IS_INT(v) ((v.as_uint64 & NANISH_MASK) == INTEGER_MASK)

#define GET_AS_DOUBLE(v) (v.as_double)
#define GET_AS_OBJECT_PTR(v) ((void*)(v.as_uint64 & 0xFFFFFFFFFFFF))
#define GET_AS_STRING_PTR(v) ((char*)(v.as_uint64 & 0xFFFFFFFFFFFF))
#define GET_AS_BOOL(v) ((char)(v.as_uint64 & 0x1))
#define GET_AS_INT(v) ((int32_t)(v.as_uint64))

#define MAKE_OBJECT_PTR(p) ((uint64_t)(p) | OBJECT_MASK)
#define MAKE_STRING_PTR(p) ((uint64_t)(p) | STRING_MASK)
#define MAKE_INT(i) ((uint64_t)(i) | INTEGER_MASK)

typedef union {
  uint64_t as_uint64;
  double as_double;
} value;

void* g_some_object;
char* g_some_string;
double g_some_double;
int g_some_int;

void mockDisplayValue(value foo){
  
  if(IS_OBJECT_PTR(foo)){
    g_some_object = GET_AS_OBJECT_PTR(foo);
  }
  else if(IS_STRING_PTR(foo)){
    g_some_string = GET_AS_STRING_PTR(foo);
  }
  else if(IS_DOUBLE(foo)){
    g_some_double = GET_AS_DOUBLE(foo);
  }
  else if(IS_INT(foo)){
    g_some_int = GET_AS_INT(foo);
  }
  else if(IS_BOOL(foo)){
    g_some_int = GET_AS_BOOL(foo) ? 234 : 567;
  }
  else if(IS_NULL(foo)){
    g_some_int = 3455;
  }
  else{
    printf("undefined");
  }

}


int main(){

  char* some_string;
  void* some_object;
  double* some_double;

  some_object = malloc(sizeof(int));
  some_string = malloc(sizeof(char) * 6);
  some_double = malloc(sizeof(double));

  clock_t begin = clock();

  srand(123);

  value* list = malloc(sizeof(value) * 10000000);

  for(int i = 0; i < 500000000; i++){
    int r = rand() % 6;

    value foo = list[rand() % 10000000];

    switch(r){
      case 0:
        foo.as_uint64 = MAKE_OBJECT_PTR(some_object);
        break;
      case 1:
        foo.as_uint64 = MAKE_STRING_PTR(some_string);
        break;
      case 2:
        foo.as_uint64 = MAKE_INT(rand());
        break;
      case 3:
        foo.as_uint64 = (rand() % 2) ? TRUE_VALUE : FALSE_VALUE;
        break;
      case 4:
        foo.as_uint64 = NULL_VALUE;
        break;
      case 5:
        foo.as_double = rand() * 1.0;
        break;
    }

    mockDisplayValue(foo);

  }


  clock_t end = clock();
  double time_spent = (double)(end - begin) / CLOCKS_PER_SEC;

  printf("\t Rubbish: %lf, %s, %p, %d\n", g_some_double, g_some_string, g_some_object, g_some_int);

  printf("Result: %lfs\n", time_spent);

	return 0;
}