#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <time.h>

#define NULL_VALUE 0x6
#define TRUE_VALUE 0x1E
#define FALSE_VALUE 0x0E

#define IS_OBJECT_PTR(v) ((v.as_uint64 & 0x7) == 0x0)
#define IS_STRING_PTR(v) ((v.as_uint64 & 0x7) == 0x2)
#define IS_DOUBLE_PTR(v) ((v.as_uint64 & 0x7) == 0x4)
#define IS_NULL(v) (v.as_uint64 == NULL_VALUE)
#define IS_BOOL(v) ((v.as_uint64 & 0xF) == 0xE)
#define IS_INT(v) (v.as_uint64 & 0x1)

#define GET_AS_OBJECT_PTR(v) (v.as_object_ptr)
#define GET_AS_STRING_PTR(v) ((char*)(v.as_uint64 ^ 0x2))
#define GET_AS_DOUBLE_PTR(v) ((double*)(v.as_uint64 ^ 0x4))
#define GET_AS_BOOL(v) ((char)(v.as_uint64 >> 4))
#define GET_AS_INT(v) ((int32_t)(v.as_uint64 >> 1))

#define MAKE_OBJECT_PTR(p) ((uint64_t)(p))
#define MAKE_STRING_PTR(p) ((uint64_t)(p) | 0x2)
#define MAKE_DOUBLE_PTR(p) ((uint64_t)(p) | 0x4)
#define MAKE_INT(i) (((uint64_t)(i) << 1) | 0x1)



typedef union {
  uint64_t as_uint64;
  void* as_object_ptr;
} value;


void* g_some_object;
char* g_some_string;
double g_some_double;
int g_some_int;

void mockDisplayValue(value foo){
  
  if(IS_OBJECT_PTR(foo)){
    g_some_object = GET_AS_OBJECT_PTR(foo);
  }
  else if(IS_STRING_PTR(foo)){
    g_some_string = GET_AS_STRING_PTR(foo);
  }
  else if(IS_DOUBLE_PTR(foo)){
    g_some_double = *GET_AS_DOUBLE_PTR(foo);
  }
  else if(IS_INT(foo)){
    g_some_int = GET_AS_INT(foo);
  }
  else if(IS_BOOL(foo)){
    g_some_int = GET_AS_BOOL(foo) ? 234 : 567;
  }
  else if(IS_NULL(foo)){
    g_some_int = 3455;
  }
  else{
    printf("undefined");
  }

}


int main(){

  char* some_string;
  void* some_object;
  double* some_double;

  some_object = malloc(sizeof(int));
  some_string = malloc(sizeof(char) * 6);
  some_double = malloc(sizeof(double));

  clock_t begin = clock();

  srand(123);

  value* list = malloc(sizeof(value) * 10000000);

  for(int i = 0; i < 500000000; i++){
    int r = rand() % 6;

    value foo = list[rand() % 10000000];

    switch(r){
      case 0:
        foo.as_uint64 = MAKE_OBJECT_PTR(some_object);
        break;
      case 1:
        foo.as_uint64 = MAKE_STRING_PTR(some_string);
        break;
      case 2:
        foo.as_uint64 = MAKE_INT(rand());
        break;
      case 3:
        foo.as_uint64 = (rand() % 2) ? TRUE_VALUE : FALSE_VALUE;
        break;
      case 4:
        foo.as_uint64 = NULL_VALUE;
        break;
      case 5:
      	*some_double = rand() * 1.0;
        foo.as_uint64 = MAKE_DOUBLE_PTR(some_double);
        break;
    }

    mockDisplayValue(foo);

  }


  clock_t end = clock();
  double time_spent = (double)(end - begin) / CLOCKS_PER_SEC;

  printf("\t Rubbish: %lf, %s, %p, %d\n", g_some_double, g_some_string, g_some_object, g_some_int);

  printf("Result: %lfs\n", time_spent);

  return 0;
}