#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <time.h>

typedef struct {
  enum {
    TYPE_DOUBLE,
    TYPE_INT,
    TYPE_STRING,
    TYPE_OBJECT,
    TYPE_BOOLEAN,
    TYPE_NULL
  } type;

  double as_double;
  int32_t as_int;
  char* as_string;
  void* as_object;
  char as_boolean; //There is no bool type in old C
} value;


void* g_some_object;
char* g_some_string;
double g_some_double;
int g_some_int;



void mockDisplayValue(value foo){
  
  if(foo.type == TYPE_OBJECT){
    g_some_object = foo.as_object;
  }
  else if(foo.type == TYPE_STRING){
    g_some_string = foo.as_string;
  }
  else if(foo.type == TYPE_DOUBLE){
    g_some_double = foo.as_double;
  }
  else if(foo.type == TYPE_INT){
    g_some_int = foo.as_int;
  }
  else if(foo.type == TYPE_BOOLEAN){
    g_some_int = foo.as_boolean ? 234 : 567;
  }
  else if(foo.type == TYPE_NULL){
    g_some_int = 3455;
  }
  else{
    printf("undefined");
  }

}


int main(){

  char* some_string;
  void* some_object;
  double* some_double;

  some_object = malloc(sizeof(int));
  some_string = malloc(sizeof(char) * 6);
  some_double = malloc(sizeof(double));

  clock_t begin = clock();

  srand(123);

  value* list = malloc(sizeof(value) * 100000000);

  for(int i = 0; i < 500000000; i++){
    int r = rand() % 6;

    value foo = list[rand() % 100000000];

    switch(r){
      case 0:
        foo.type = TYPE_OBJECT;
        foo.as_object = some_object;
        break;
      case 1:
        foo.type = TYPE_STRING;
        foo.as_string = some_string;
        break;
      case 2:
        foo.type = TYPE_INT;
        foo.as_int = rand();
        break;
      case 3:
        foo.type = TYPE_BOOLEAN;
        foo.as_boolean = rand() % 2;
        break;
      case 4:
        foo.type = TYPE_NULL;
        break;
      case 5:
        foo.type = TYPE_DOUBLE;
        foo.as_double = rand() * 1.0;
        break;
    }

    mockDisplayValue(foo);

  }


  clock_t end = clock();
  double time_spent = (double)(end - begin) / CLOCKS_PER_SEC;

  printf("\t Rubbish: %lf, %s, %p, %d\n", g_some_double, g_some_string, g_some_object, g_some_int);

  printf("Result: %lfs\n", time_spent);

  return 0;
}