#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <time.h>

typedef struct {
  enum {
    TYPE_DOUBLE,
    TYPE_INT,
    TYPE_STRING,
    TYPE_OBJECT,
    TYPE_BOOLEAN,
    TYPE_NULL
  } type;

  union {
    double double_num;
    int32_t int_num;
    char* string_ptr;
    void* object_ptr;
    char boolean; //There is no bool type in old C
  } as;
  
} value;


void* g_some_object;
char* g_some_string;
double g_some_double;
int g_some_int;



void mockDisplayValue(value foo){
  
  if(foo.type == TYPE_OBJECT){
    g_some_object = foo.as.object_ptr;
  }
  else if(foo.type == TYPE_STRING){
    g_some_string = foo.as.string_ptr;
  }
  else if(foo.type == TYPE_DOUBLE){
    g_some_double = foo.as.double_num;
  }
  else if(foo.type == TYPE_INT){
    g_some_int = foo.as.int_num;
  }
  else if(foo.type == TYPE_BOOLEAN){
    g_some_int = foo.as.boolean ? 234 : 567;
  }
  else if(foo.type == TYPE_NULL){
    g_some_int = 3455;
  }
  else{
    printf("undefined");
  }

}


int main(){

  char* some_string;
  void* some_object;
  double* some_double;

  some_object = malloc(sizeof(int));
  some_string = malloc(sizeof(char) * 6);
  some_double = malloc(sizeof(double));

  clock_t begin = clock();

  srand(123);

  value* list = malloc(sizeof(value) * 100000000);

  for(int i = 0; i < 500000000; i++){
    int r = rand() % 6;

    value foo = list[rand() % 100000000];

    switch(r){
      case 0:
        foo.type = TYPE_OBJECT;
        foo.as.object_ptr = some_object;
        break;
      case 1:
        foo.type = TYPE_STRING;
        foo.as.string_ptr = some_string;
        break;
      case 2:
        foo.type = TYPE_INT;
        foo.as.int_num = rand();
        break;
      case 3:
        foo.type = TYPE_BOOLEAN;
        foo.as.boolean = rand() % 2;
        break;
      case 4:
        foo.type = TYPE_NULL;
        break;
      case 5:
        foo.type = TYPE_DOUBLE;
        foo.as.double_num = rand() * 1.0;
        break;
    }

    mockDisplayValue(foo);

  }


  clock_t end = clock();
  double time_spent = (double)(end - begin) / CLOCKS_PER_SEC;

  printf("\t Rubbish: %lf, %s, %p, %d\n", g_some_double, g_some_string, g_some_object, g_some_int);

  printf("Result: %lfs\n", time_spent);

  return 0;
}